/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.lycanitesmobs.core.info.Beastiary;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;

public class CreatureKnowledge {
    public Beastiary beastiary;
    public String creatureName;
    public int rank;
    public int experience = 0;

    public CreatureKnowledge(Beastiary beastiary, String creatureName, int rank, int experience) {
        this.beastiary = beastiary;
        this.creatureName = creatureName;
        this.rank = rank;
        this.experience = experience;
    }

    public CreatureInfo getCreatureInfo() {
        return CreatureManager.getInstance().getCreature(this.creatureName);
    }

    public int addExperience(int experience) {
        int maxExperience = this.getMaxExperience();
        if (maxExperience <= 0) {
            return 0;
        }
        this.experience += experience;
        int remainingExperience = this.experience - maxExperience;
        if (remainingExperience >= 0) {
            ++this.rank;
            this.experience = 0;
            this.addExperience(remainingExperience);
            this.beastiary.sendAddedMessage(this);
        }
        return remainingExperience;
    }

    public int getMaxExperience() {
        if (this.rank == 1) {
            return 1000;
        }
        if (this.rank >= 2) {
            return 0;
        }
        return 1;
    }
}

